<?php

return [

    /*
    |--------------------------------------------------------------------------
    | 主页
    |--------------------------------------------------------------------------
    |
    | resources/views/home.blade.php
    |
    */

    'Log in' => '登录',
    'Register' => '注册',

    'Dashboard' => '控制面板',
    'Copyright' => '版权所有',
    'Made with' => '技术支持',
    'by' => '由',

    'HOME.MESSAGE' => '
    <p>通过<strong><a href="https://linkstack.org/"><strong>LinkStack</a></strong></a>
    这是一个注重隐私的开源<strong>链接管理平台</strong>。创建一个可自定义的个人资料页面，以便管理<strong>所有重要的链接</strong>，
    并为您的受众提供丝滑的浏览体验。</p>
    ',


    /*
    |--------------------------------------------------------------------------
    | 示例页面/首页示例页面
    |--------------------------------------------------------------------------
    |
    | resources/views/demo.blade.php
    |
    */

    'Example page' => '示例页面',


    /*
    |--------------------------------------------------------------------------
    | 认证页面
    |--------------------------------------------------------------------------
    |
    | 登录、注册、忘记密码、重置密码等。
    | 这包括诸如密码重置和电子邮件验证等认证电子邮件。
    | resources/views/auth
    |
    */

    # 登录页面
    'Sign In' => '登录',
    'Login to stay connected' => '登录以继续保持联接',
    'Email' => '电子邮箱地址',
    'Password' => '密码',
    'Remember Me' => '记住我',
    'Forgot Password?' => '忘记密码？',
    'or sign in with other accounts?' => '或使用其他账户登录？',
    'Don’t have an account?' => '还没有账户？',
    'Click here to sign up' => '点击此处注册',


    # 重置密码
    'Forgot your password?' => '忘记密码了吗？',
    'No problem' => '没问题。只需告知我们您的电子邮箱地址，我们将发送密码重置链接，让您选择一个新密码。',
    'Email Password Reset Link' => '发送密码重置链接',


    # 注册页面
    'Sign Up' => '注册',
    'Register to stay connected' => '注册以保持连接',
    'Display Name' => '显示名称',
    'Confirm Password' => '确认密码',
    'Already have an account?' => '已经拥有账户？',
    'Click here to sign in' => '点击此处登录',


    # 等待管理员验证
    'Verification Status' => '验证状态',
    'auth_pending' => '您的账户仍在等待验证',
    'auth_unverified' => '您的账户当前未验证，需要管理员手动验证。',
    'Log out' => '退出',


    # 密码确认
    'auth_password' => '此为应用安全敏感区域，请在继续前验证您的密码。',
    'Confirm' => '确认',


    # 重设密码
    'Reset Password' => '重设密码',
    'Enter a new password' => '输入新密码',


    # 测试电子邮件
    'Test E-Mail' => '测试发送电子邮件',


    # 注册通知电子邮件
    'A new user has registered on' => '一个新用户已在此注册',
    'and is awaiting verification' => '并正在等待验证',
    'The user' => '该用户',
    'with the email' => '使用电子邮件',
    'has registered a new account on' => '已在此注册新账户',
    'and is awaiting confirmation by an admin' => '并正在等待管理员确认。',
    'Click' => '点击',
    'here' => '这里',
    'to verify the user' => '以验证用户。',
    'Manage Users' => '管理用户',


    # 电子邮件验证电子邮件
    'auth_thanks' => '感谢您的注册！在开始之前，您可以通过点击我们刚刚发送给您的链接来验证您的电子邮件地址吗？如果您没有收到电子邮件，我们会很乐意再发送一封。如果几分钟内没有看到电子邮件，请检查您的垃圾邮件或垃圾邮件文件夹。',
    'auth_verification' => '一个新的验证链接已发送到您在注册期间提供的电子邮件地址。',
    'Resend Verification Email' => '重新发送验证电子邮件',


    /*
    |--------------------------------------------------------------------------
    | 样式滑入
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'Settings' => '设置',
    'Scheme' => '配色方案',
    'Auto' => '自动',
    'Dark' => '深色',
    'Light' => '浅色',
    'Color Customizer' => '颜色自定义',
    'Sidebar Color' => '侧边栏颜色',
    'Default' => '默认',
    'Color' => '颜色',
    'Transparent' => '透明',
    'Sidebar Types' => '侧边栏类型',
    'Mini' => '迷你',
    'Hover' => '悬停',
    'Boxed' => '有框的',
    'Sidebar Active Style' => '侧边栏活动样式',
    'Rounded One Side' => '一侧圆角',
    'Rounded All' => '全部圆角',
    'Pill One Side' => '一侧药丸形',
    'Pill All' => '全部药丸形',


    /*
    |--------------------------------------------------------------------------
    | 站点定制
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/site.blade.php
    |
    */

    'Home' => '首页',
    'Add Link' => '添加链接',
    'Administration' => '管理',
    'Admin' => '管理员',
    'Config' => '配置',
    'Footer Pages' => '页脚页面',
    'Site Customization' => '站点定制',
    'Site Logo' => '站点标志',
    'Personalization' => '个性化',
    'Links' => '链接',
    'Appearance' => '外观',
    'Themes' => '主题',
    'Site logo' => '站点标志',
    'Favicon' => '网站图标',
    'Home message' => '首页信息',


    /*
    |--------------------------------------------------------------------------
    | 导航栏
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'View Page' => '查看页面',
    'Share your profile' => '分享您的个人资料',
    'Share your profile:' => '分享您的个人资料：',
    'Error sharing:' => '分享出错：',
    'Text copied to clipboard!' => '文本已复制到剪贴板！',
    'Error copying text:' => '复制文本出错：',
    'QR Code' => '二维码',
    'Scan QR Code' => '扫描二维码',
    'QR code could not be generated' => '无法生成二维码',
    'Reason:' => '原因：',

    # 二维码下拉菜单
    'Close' => '关闭',
    'Dismiss' => '取消',

    # 通知下拉菜单
    'All Notifications' => '所有通知',

    # 更新程序下拉菜单
    'Updater' => '更新程序',
    'Beta Mode' => '测试模式',
    'Local version' => '本地版本',
    'Latest beta' => '最新测试版',
    'Run updater' => '运行更新程序',
    'Update available' => '有可用更新',
    'Up to date' => '已是最新',
    'Check again' => '再次检查',

    # 导航栏中的用户部分
    'Administrator' => '管理员',
    'Verified user' => '已验证用户',
    'User' => '用户',
    'Profile' => '个人资料',
    'Styling' => '样式',
    'Logout' => '登出',


    /*
    |--------------------------------------------------------------------------
    | 仪表板页面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/index.blade.php
    |
    */

    # 带图片的页眉
    'Hi' => '您好',
    'stranger' => '陌生人',
    'welcome' => '欢迎来到 :appName！',
    'Set a handle' => '设置一个标识',

    # 仪表板页面
    'Total Links:' => '链接总数：',
    'Link Clicks:' => '链接点击数：',
    'View/Edit Links' => '查看/编辑链接',
    'Top Links:' => '热门链接：',
    'You haven’t added any links yet' => '您还没有添加任何链接。',
    'clicks' => '点击数',
    'Clicks' => '点击数',
    'Site statistics:' => '网站统计：',
    'Total links' => '链接总数',
    'Total clicks' => '点击总数',
    'Total users' => '用户总数',
    'Registrations:' => '注册数：',
    'Last 30 days' => '过去30天',
    'Last 7 days' => '过去7天',
    'Last 24 hours' => '过去24小时',
    'Active users:' => '活跃用户：',



    /*
    |--------------------------------------------------------------------------
    | 按钮编辑器
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/button-editor.blade.php
    |
    */

    'Button Editor' => '按钮编辑器',
    'Back' => '返回',
    'Custom Button' => '自定义按钮',
    'CSS' => 'CSS',
    'background' => '背景',
    'gradient' => '渐变',
    'Show CSS' => '显示CSS',
    'Custom CSS' => '自定义CSS',
    'Save' => '保存',
    'Reset to default' => '恢复默认',
    'Result' => '结果：',
    'Custom Icon' => '自定义图标',
    'Custom Alert' => '您的自定义图标短代码中未包含字符串“fa-”，请始终使用如“fa-ghost”格式的图标。',
    'cb.description.1-4' => '可以通过 Font Awesome 向按钮添加自定义图标。您可以使用下面列表中的任何图标，您可以通过点击“查看所有图标”按钮访问此列表。列表中的每个图标都有一个短代码，您可以复制并输入到自定义图标字段中。',
    'cb.description.2-4' => '每个图标的短代码都由前缀和主要部分组成。如果短代码不是品牌图标，您可以简单地输入格式为：fa-icon-name的代码。“fa-...”格式在此很重要。例如“fa-code”。',
    'cb.description.3-4' => '如果短代码是品牌图标，重要的是在短代码部分之前包含“fab”。同样，“fa-...”格式在此仍然适用。例如，“fab fa-github”。',
    'cb.description.4-4' => '要为您的图标应用颜色，您可以简单地写出颜色名称或在图标前写下HEX值，后跟一个“;”。在这里，将颜色放在图标短代码前很重要，并且颜色代码必须以分号结束。<br>您可以在<a href="https://www.w3schools.com/cssref/css_colors.asp" target="_blank">这里</a>找到可用颜色列表。',
    'Style' => '样式',
    'Prefix' => '前缀',
    'Icon' => '图标',
    'Short Code' => '短代码',
    'Regular' => '常规',
    'Brands' => '品牌',
    'Color name' => '颜色名称',
    'Color HEX' => '颜色HEX',
    'Color HEX1' => '颜色HEX',
    'Update icon' => '更新图标',
    'See all icons' => '查看所有图标',


    /*
    |--------------------------------------------------------------------------
    | 编辑链接页面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/edit-link.blade.php
    |
    */

    'Edit' => '编辑',
    'Add' => '添加',
    'Block' => '块',
    'Blocks' => '块：',
    'Select Block' => '选择块',
    'Toggle Dropdown' => '切换下拉菜单',
    'Cancel' => '取消',
    'Save and Add More' => '保存并添加更多',
    'Click to change link blocks' => '点击更改链接块',
    'Click for a list of available link blocks' => '点击查看可用链接块列表',


    /*
    |--------------------------------------------------------------------------
    | 链接页面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/links.blade.php
    |
    */

    'My Links' => '我的链接',
    'Add new Link' => '添加新链接',
    'No Link Added' => '尚未添加链接。',
    'Download' => '下载',
    'Preview' => '预览：',
    'No compatible browser' => '您的浏览器不兼容',
    'Page Icons' => '页面图标',
    'Save links' => '保存链接',

    # 工具提示
    'Customize' => '自定义',
    'Delete' => '删除',
    'Clear icon cache' => '清除图标缓存',

    'confirm_delete' => '您确定要删除 :title 吗？',


    /*
    |--------------------------------------------------------------------------
    | “我的个人资料”/“外观”页面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/page.blade.php
    |
    */

    'My Profile'=> '我的个人资料',
    'Profile Picture' => '个人资料图片',
    'Page URL' => '页面URL',
    'Display name' => '显示名称',
    'Name:' => '名称：',
    'Page Description' => '页面描述',
    'Show checkmark' => '显示勾选标记',
    'disableverified' => '您是已验证用户。此设置允许您在页面上隐藏您的勾选标记。',
    'Show share button' => '显示分享按钮',
    'disablesharebutton' => '此设置允许您在页面上隐藏分享按钮。',
    'Open links in new tab' => '在新标签页中打开链接',
    'openlinksnewtab' => '此设置决定您的链接页面上的链接是在同一标签页中打开还是在新标签页中打开。',


    /*
    |--------------------------------------------------------------------------
    | 个人设置页面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/profile.blade.php
    |
    */

    'Account Settings' => '账户设置',
    'Change email' => '更改邮箱',
    'Change password' => '更改密码',
    'Export user data' => '导出用户数据',
    'Export your user data' => '导出您的用户数据以转移到另一个实例。',
    'Export all data' => '导出所有数据',
    'Export links only' => '仅导出链接',
    'Import user data' => '导入用户数据',
    'import.user.alert' => '您确定要导入此文件吗？此操作将替换您当前的所有数据，包括链接！',
    'Import your user data from another instance' => '从另一个实例导入您的用户数据。',
    'Import' => '导入',
    'Delete your account' => '删除您的账户',
    'You are about to delete' => '您即将删除您的账户！',
    'You are about to delete This action cannot be undone' => '您即将删除您的账户！此操作无法撤销。',
    'Delete account' => '删除账户',

    # 警告
    'Profile updated successfully!' => '个人资料更新成功！',
    'An error occurred while updating your profile.' => '更新您的个人资料时发生错误。',

    'That handle has already been taken' => '该句柄已被占用。',
    'The selected file must be an image' => '所选文件必须是图片。',
    'The image must be' => '图片必须是：',
    'The image size should not exceed 2MB' => '图片大小不应超过2MB。',
    'Please select an image' => '请选择一张图片。',


    /*
    |--------------------------------------------------------------------------
    | 主题页面
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme.blade.php
    |
    */

    'Select a theme' => '选择主题',
    'Select theme' => '选择主题',
    'Custom background' => '自定义背景',
    'No image selected' => '未选择图片',
    'Remove background' => '移除背景',
    'Manage themes' => '管理主题',
    'Loading...' => '加载中...',
    'Upload themes' => '上传主题',
    'Delete themes' => '删除主题',
    'Download themes' => '下载主题',
    'Delete a theme' => '删除一个主题',


    /*
    |--------------------------------------------------------------------------
    | 主题更新器
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme-updater.blade.php
    |
    */

    'Theme Updater' => '主题更新器',
    'Theme name' => '主题名称：',
    'Update status' => '更新状态：',
    'Version' => '版本：',
    'Error!' => '错误！',
    'Update manually' => '手动更新',
    'Update all themes' => '更新所有主题',


    /*
    |--------------------------------------------------------------------------
    | 编辑用户页面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/edit-user.blade.php
    |
    */

    'Edit User' => '编辑用户',
    'Logo' => '标志',
    'Page description' => '页面描述',
    'Role' => '角色',


    /*
    |--------------------------------------------------------------------------
    | 链接页面（管理员视图）
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Title' => '标题',


    /*
    |--------------------------------------------------------------------------
    | Links Page (Admin)
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Link' => '链接',


    /*
    |--------------------------------------------------------------------------
    | PHP info Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/phpinfo.blade.php
    |
    */

    'Information about PHP’s configuration' => '关于 PHP 配置的信息',
    'Outputs information about the current state of PHP' => '输出有关当前 PHP 状态的信息',


    /*
    |--------------------------------------------------------------------------
    | Delete themes page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/theme.blade.php
    |
    */

    'Delete theme' => '删除主题',


    /*
    |--------------------------------------------------------------------------
    | 管理用户页面
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/users.blade.php
    |
    */

    'Users:' => '用户：',
    'Search user' => '搜索用户',
    'ID' => 'ID',
    'Name' => '姓名',
    'E-Mail' => '电子邮箱',
    'Page' => '页面',
    'Created at' => '创建于',
    'Last seen' => '最后登录',
    'Status' => '状态',
    'Action' => '操作',
    'N/A' => '不适用',
    'Pending' => '待审',
    'Verified' => '已验证',
    'Approved' => '已批准',
    'Add new user' => '添加新用户',

    # 工具提示
    'tt.Delete' => '删除',
    'tt.Impersonate' => '模拟',
    'tt.Edit' => '编辑',
    'tt.All links' => '所有链接',

    'confirm.delete.user' => '您确定要删除这个用户吗？\n此操作无法撤销！',

    # 日期格式
    'date.format' => 'd/m/Y',

    'days ago' => '天前',
    '1 day ago' => '1 天前',
    'Today' => '今天',
    '1 year ago' => '1 年前',
    'years ago' => '年前',


    /*
    |--------------------------------------------------------------------------
    | 配置页面
    |--------------------------------------------------------------------------
    |
    | resources/views/components/config/
    | resources/views/panel/config-editor.blade.php
    |
    */

    'Advanced Config' => '高级配置',
    'Take Backup' => '备份',
    'All Backups' => '所有备份',
    'Diagnosis' => '诊断',

    'Alternative Config Editor' => '替代配置编辑器',
    'Use the Alternative Config Editor to edit the config directly' => '使用替代配置编辑器直接编辑配置',

    'PHP info' => 'PHP信息',
    'Display debugging information about your PHP setup' => '显示关于您的PHP设置的调试信息',

    'Jump directly to:' => '直接跳转到：',

    'Application' => '应用程序',
    'Panel settings' => '面板设置',
    'Security' => '安全',
    'Advanced' => '高级',
    'SMTP' => 'SMTP',
    'Footer links' => '页脚链接',
    'Debug' => '调试',
    'Language' => '语言',

    'default' => '默认',
    'Apply' => '应用',

    'AC.description' => '允许编辑您的网站前端。除其他外，此文件允许自定义：首页、链接、标题、谷歌分析和元标签。',
    'Advanced Configuration file.' => '高级配置文件。',
    'Restore defaults' => '恢复默认',

    'Backup' => '备份',
    'You can back up your entire instance:' => '您可以备份整个实例：',
    'The backup system won’t save more than two backups at a time' => '备份系统一次不会保存超过两个备份。',
    'Backup Instance' => '备份实例',

    'wtrue' => '一切正常运行！',
    'wfalse' => '此文件无法写入。这可能妨碍正常运行。',
    'utrue' => '您的安全处于风险中。这个文件可以被所有人访问。需要立即采取行动！',
    'ufalse' => '一切正常运行！',
    'unull' => '出现了一些问题。如果您在代理或Docker容器后面运行，这可能是正常的。',
    'Debugging information' => '调试信息',
    'security.risk' => '您的安全处于风险中。某些文件可以被所有人访问。需要立即采取行动！点击此消息了解更多。',
    'security.risk.1-3' => '在这里，您可以轻松验证是否可以从外部访问关键系统文件。重要的是这些文件不能被访问，否则像密码这样的用户数据可能会泄露。标有',
    'security.risk.2-3' => '的条目不能从外部访问，标有',
    'security.risk.3-3' => '的条目可以被任何人访问，需要立即采取行动以保护您的数据。',
    'Hover for more' => '悬停了解更多',
    'Write access' => '写入权限',
    'Write access.description.1-3' => '在这里，您可以轻松验证是否可以写入重要的系统文件。这对于每个功能的正常工作都很重要。标有',
    'Write access.description.2-3' => '的条目按预期工作，标有',
    'Write access.description.3-3' => '的条目不行。',
    'File' => '文件',
    'Dependencies' => '依赖',
    'Required PHP modules' => '所需的PHP模块。',
    'PHP Extension' => 'PHP扩展',
    'No backups found' => '未找到备份',
    'Backup your instance' => '备份您的实例',

    'Go back' => '返回',

    'Strings with a # in front of them are comments and wont affect anything' => '前面有#的字符串是注释，不会影响任何事情。',

    'Download your updater backups:' => '下载您的更新器备份：',
    'The server will never store more that two backups at a time' => '服务器一次永远不会存储超过两个备份。',

    'SMTP.title' => '使用内置SMTP服务器',
    'SMTP.description' => '使用由LinkStack提供的SMTP服务器。可能不是100%可靠。必须禁用它才能使用自定义SMTP服务器。',
    'SMTP.description.alt' => '（在下方用“应用更改”保存更改）',
    'Enable' => '启用',
    'Custom SMTP server:' => '自定义SMTP服务器：',
    'Host' => '主机',
    'Port' => '端口',
    'Username' => '用户名',
    'Encryption type' => '加密类型',
    'From address' => '发件人地址',
    'Apply changes' => '应用更改',
    'Test E-Mail setup:' => '测试电子邮件设置：',
    'Send Test E-Mail' => '发送测试电子邮件',

    'Debug.title' => '调试模式',
    'Debug.description' => '在生产环境中应该禁用。在设置过程中用于调试。',

    'DISPLAY_FOOTER_HOME.title' => '首页页脚链接',
    'DISPLAY_FOOTER_HOME.description' => '启用首页页脚链接。',
    'REGISTER_AUTH.title' => '启用电子邮件验证',
    'REGISTER_AUTH.description' => '决定用户注册时是否必须验证他们的电子邮件。',
    'ALLOW_REGISTRATION.title' => '启用注册',
    'ALLOW_REGISTRATION.description' => '决定用户是否可以为您的应用程序注册。',
    'NOTIFY_EVENTS.title' => '通知事件',
    'NOTIFY_EVENTS.description' => '如果正在进行事件，则显示通知。',
    'NOTIFY_UPDATES.title' => '通知更新',
    'NOTIFY_UPDATES.description' => '如果有新的更新可用，则显示通知。',
    'DISPLAY_FOOTER.title' => '显示页脚',
    'DISPLAY_FOOTER.description' => '决定是否应显示页脚链接。',
    'DISPLAY_CREDIT.title' => '在用户页面上显示信用',
    'DISPLAY_CREDIT.description' => '决定是否应在用户页面上显示信用通知。',
    'DISPLAY_CREDIT_FOOTER.title' => '在页脚中显示信用',
    'DISPLAY_CREDIT_FOOTER.description' => '决定是否应在页脚中显示信用通知。',
    'HOME_URL.title' => '将用户页面设置为首页',
    'HOME_URL.description' => '将一个用户页面设置为首页。这将把之前的首页移动到example.com/home。',
    'ALLOW_USER_HTML.title' => '允许在用户的描述中使用扩展语法',
    'ALLOW_USER_HTML.description' => '这使用户能够在其页面描述中使用特殊格式，如标题和链接。<br>这通常被认为是安全的。',
    'APP_NAME.title' => '应用程序标题',
    'APP_NAME.description' => '设置您的应用程序的标题。更改将注销每个活跃用户。',
    'APP_KEY.title' => 'APP_KEY',
    'APP_KEY.description' => 'APP_KEY',
    'APP_URL.title' => 'APP_URL',
    'APP_URL.description' => 'APP_URL',
    'ENABLE_BUTTON_EDITOR.title' => '启用按钮编辑器',
    'ENABLE_BUTTON_EDITOR.description' => '决定用户是否被允许使用CSS自定义他们自己的按钮。',
    'APP_DEBUG.title' => 'APP_DEBUG',
    'APP_DEBUG.description' => 'APP_DEBUG',
    'APP_ENV.title' => 'APP_ENV',
    'APP_ENV.description' => 'APP_ENV',
    'LOG_CHANNEL.title' => 'LOG_CHANNEL',
    'LOG_CHANNEL.description' => 'LOG_CHANNEL',
    'LOG_LEVEL.title' => 'LOG_LEVEL',
    'LOG_LEVEL.description' => 'LOG_LEVEL',
    'MAINTENANCE_MODE.title' => '启用维护模式',
    'MAINTENANCE_MODE.description' => '在所有公共页面上显示维护消息。这将禁用登录页面。',
    'MAIL_MAILER.title' => 'MAIL_MAILER',
    'MAIL_MAILER.description' => 'MAIL_MAILER',
    'MAIL_HOST.title' => 'MAIL_HOST',
    'MAIL_HOST.description' => 'MAIL_HOST',
    'MAIL_PORT.title' => 'MAIL_PORT',
    'MAIL_PORT.description' => 'MAIL_PORT',
    'MAIL_USERNAME.title' => 'MAIL_USERNAME',
    'MAIL_USERNAME.description' => 'MAIL_USERNAME',
    'MAIL_PASSWORD.title' => 'MAIL_PASSWORD',
    'MAIL_PASSWORD.description' => 'MAIL_PASSWORD',
    'MAIL_ENCRYPTION.title' => 'MAIL_ENCRYPTION',
    'MAIL_ENCRYPTION.description' => 'MAIL_ENCRYPTION',
    'MAIL_FROM_ADDRESS.title' => 'MAIL_FROM_ADDRESS',
    'MAIL_FROM_ADDRESS.description' => 'MAIL_FROM_ADDRESS',
    'JOIN_BETA.title' => '加入Beta计划',
    'JOIN_BETA.description' => '在更新时启用beta版本的使用。在<a target=\'_blank\' href=\'https://linkstack.org/b\'>这里</a>了解更多。',
    'SKIP_UPDATE_BACKUP.title' => '跳过更新备份',
    'SKIP_UPDATE_BACKUP.description' => '在更新时跳过备份。建议始终禁用此选项，<br>但在某些配置中可能会导致错误。',
    'CUSTOM_META_TAGS.title' => '启用自定义元标签',
    'CUSTOM_META_TAGS.description' => '在所有页面的头部启用自定义元标签的使用。在高级配置中定义。',
    'FORCE_HTTPS.title' => '强制链接HTTPS',
    'FORCE_HTTPS.description' => '默认情况下使所有链接使用HTTPS。如果您使用反向代理，建议启用此选项。',
    'ALLOW_CUSTOM_CODE_IN_THEMES.title' => '允许在主题中使用自定义代码',
    'ALLOW_CUSTOM_CODE_IN_THEMES.description' => '允许在主题中使用自定义代码。如果您使用来自未知来源的主题，<br>这可能构成安全风险。',
    'ENABLE_ADMIN_BAR_USERS.title' => '为所有用户启用管理员栏',
    'ENABLE_ADMIN_BAR_USERS.description' => '如果启用，所有经过身份验证的用户都将在其链接页面上显示管理员栏。',
    'ENABLE_THEME_UPDATER.title' => '启用主题更新器',
    'ENABLE_THEME_UPDATER.description' => '决定主题更新器是否应该处于活动状态。',
    'ENABLE_SOCIAL_LOGIN.title' => '启用社交登录',
    'ENABLE_SOCIAL_LOGIN.description' => '启用社交登录。此选项需要进一步设置。在<a target=\'_blank\' href=\'https://linkstack.org/social-login\'>这里</a>了解更多。',
    'USE_THEME_PREVIEW_IFRAME.title' => '使用iframe作为主题预览',
    'USE_THEME_PREVIEW_IFRAME.description' => '决定是否应使用内部iframe作为主题页面的预览。',
    'FORCE_ROUTE_HTTPS.title' => '将所有页面重定向到HTTPS',
    'FORCE_ROUTE_HTTPS.description' => '如果使用反向代理，此选项将破坏您的设置。',
    'DISPLAY_FOOTER_TERMS.title' => '条款页脚链接',
    'DISPLAY_FOOTER_TERMS.description' => '启用条款页脚链接。',
    'DISPLAY_FOOTER_PRIVACY.title' => '隐私页脚链接',
    'DISPLAY_FOOTER_PRIVACY.description' => '启用隐私页脚链接。',
    'DISPLAY_FOOTER_CONTACT.title' => '联系页脚链接',
    'DISPLAY_FOOTER_CONTACT.description' => '启用联系页脚链接。',
    'TITLE_FOOTER_HOME.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_HOME.description' => '首页页脚链接的标题。',
    'TITLE_FOOTER_TERMS.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_TERMS.description' => '条款页脚链接的标题。',
    'TITLE_FOOTER_PRIVACY.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_PRIVACY.description' => '隐私页脚链接的标题。',
    'TITLE_FOOTER_CONTACT.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_CONTACT.description' => '联系页脚链接的标题。',
    'HOME_FOOTER_LINK.title' => '<div style="margin-top:-40px">首页页脚链接URL</div>',
    'HOME_FOOTER_LINK.description' => '输入任何URL以重定向您的首页链接URL。<br>留空使用默认链接。',
    'ALLOW_CUSTOM_BACKGROUNDS.title' => '允许自定义背景',
    'ALLOW_CUSTOM_BACKGROUNDS.description' => '允许用户为其页面上传自定义背景图片。',
    'ALLOW_USER_IMPORT.title' => '允许用户从其他实例导入配置文件',
    'ALLOW_USER_IMPORT.description' => '允许用户从外部文件导入其配置文件和链接。',
    'ALLOW_USER_EXPORT.title' => '允许用户导出其配置文件',
    'ALLOW_USER_EXPORT.description' => '允许用户导出其自己的链接和配置文件。',
    'MANUAL_USER_VERIFICATION.title' => '手动验证用户',
    'MANUAL_USER_VERIFICATION.description' => '决定管理员是否必须手动验证新注册的用户。',
    'ADMIN_EMAIL.title' => '管理员电子邮件',
    'ADMIN_EMAIL.description' => '用于发送通知电子邮件。',
    'HIDE_VERIFICATION_CHECKMARK.title' => '隐藏验证勾选标记',
    'HIDE_VERIFICATION_CHECKMARK.description' => '隐藏在管理员和VIP页面上显示的验证徽章。',
    'ENABLE_REPORT_ICON.title' => '启用报告图标',
    'ENABLE_REPORT_ICON.description' => '在用户页面上显示一个图标，允许用户报告页面。',
    'LOCALE.title' => '应用程序区域设置',
    'LOCALE.description' => '更改您的应用程序的语言',


    /*
    |--------------------------------------------------------------------------
    | 安装
    |--------------------------------------------------------------------------
    |
    | resources/views/installer/installer.blade.php
    |
    */

    # 标题标签
    'LinkStack setup' => 'LinkStack 设置',

    'Setup LinkStack' => '设置 LinkStack',
    'Welcome to the setup for LinkStack!' => '欢迎使用 LinkStack 设置！',
    'This setup will:' => '本设置将：',
    'Check the server dependencies' => '1. 检查服务器依赖项',
    'Setup the database' => '2. 设置数据库',
    'Create the admin user' => '3. 创建管理员用户',
    'Configure the app' => '4. 配置应用程序',
    'Choose a language' => '选择语言',
    'setup.disclaimer' => '继续即表示您同意遵守我们的',
    'Terms and Conditions' => '条款和条件',

    'Next' => '下一步',
    'Yes' => '是',
    'No' => '否',
    'Finish setup' => '完成设置',

    'Setup failed' => '设置失败',
    'An error has occured. Please try again' => '发生错误，请重试',
    'Depending on your database type:' => '根据您的数据库类型：',
    'Try again' => '重试',

    'Dependency check' => '依赖性检查',
    'Required PHP modules:' => '所需 PHP 模块：',

    'Select a database type' => '选择数据库类型',
    'Under most circumstances, we recommend using SQLite' => '在大多数情况下，我们建议使用 SQLite',
    'MySQL requires a separate, empty MySQL database' => 'MySQL 需要一个独立的、初始化的 MySQL 数据库',

    'Database type:' => '数据库类型：',
    'Database host:' => '数据库主机：',
    'Database port:' => '数据库端口：',
    'Database name:' => '数据库名称：',
    'Database username:' => '数据库用户名：',
    'Database password:' => '数据库密码：',

    'Create an admin account' => '创建管理员帐户',
    'Admin email:' => '管理员电子邮件：',
    'Admin password:' => '管理员密码：',
    'Handle:' => '用户名：',
    'Name:' => '姓名：',

    'Configure your page' => '配置您的页面',
    'Enable registration:' => '启用注册：',
    'Enable email verification:' => '启用电子邮件验证：',
    'Set your page as Home Page' => '将您的页面设置为主页',
    'This will move the Home Page to /home' => '这将把主页移至 /home',
    'App Name:' => '应用程序名称：',


    /*
    |--------------------------------------------------------------------------
    | 升级程序/升级备份
    |--------------------------------------------------------------------------
    |
    | resources/views/update.blade.php
    |
    */

    # 标题标签
    'Update LinkStack' => '更新 LinkStack',

    'Latest beta version' => '最新测试版',
    'Installed beta version' => '已安装测试版',
    'none' => '无',
    'You need to update to the latest mainline release' => '您需要升级到最新的主线版本',
    'You’re running the latest mainline release' => '您正在运行最新的主线版本',

    'update.manually' => '您可以自动更新您的安装，也可以下载更新并手动安装：',
    'update.windows' => 'Windows 用户可以使用替代升级程序。此升级程序不会创建备份。请谨慎使用。',
    'Update automatically' => '自动更新',

    'Updating' => '正在更新',
    'Creating backup' => '创建备份',
    'Preparing update' => '准备更新',
    'No new version' => '没有新版本',
    'There is no new version available' => '没有可用的新版本',
    'Admin Panel' => '管理员面板',
    'Finishing up' => '完成',
    'Success!' => '成功！',
    'The update was successful' => '更新成功，您现在可以返回管理员面板。',
    'View the release notes' => '查看发布说明',
    'Run again' => '重新运行',
    'Error' => '错误',
    'Something went wrong with the update' => '更新过程中出现了问题',


    /*
    |--------------------------------------------------------------------------
    | 备份
    |--------------------------------------------------------------------------
    |
    | resources/views/backup.blade.php
    |
    */

    # 标题标签
    'Backup.title' => '备份',

    'The backup was successful' => '备份成功，您现在可以返回管理员面板或查看您的所有备份。',


    /*
    |--------------------------------------------------------------------------
    | 页面区块
    |--------------------------------------------------------------------------
    |
    | 部分内容存储在数据库中。
    | resources/views/studio/edit-link.blade.php
    |
    */

    # 预定义
    'block.title.predefined' => '预定义网站',
    'block.description.predefined' => '从预定义网站列表中选择，并使用该网站的品牌颜色和图标自动为您的链接设置样式。',

    # 链接
    'block.title.link' => '自定义链接',
    'block.description.link' => '创建一个指向任何网站的自定义链接。自定义按钮样式和图标，或者使用网站的站点图标作为按钮图标。',

    # 电子名片
    'block.title.vcard' => '电子名片',
    'block.description.vcard' => '创建或上传电子名片。',

    # 电子邮件
    'block.title.email' => '电子邮件地址',
    'block.description.email' => '添加一个电子邮件地址，打开一个系统对话框来编写新电子邮件。',

    # 电话
    'block.title.telephone' => '电话号码',
    'block.description.telephone' => '添加一个电话号码，打开一个系统对话框来拨打电话。',

    # 标题
    'block.title.heading' => '标题',
    'block.description.heading' => '使用标题来组织您的链接并将它们分为不同的组。',

    # 间距
    'block.title.spacer' => '间距',
    'block.description.spacer' => '在链接列表中添加空白空间。您可以选择间距的高度。',

    # 文本
    'block.title.text' => '文本',
    'block.description.text' => '在您的页面上添加不可点击的静态文本。',


    /*
    |--------------------------------------------------------------------------
    | 页面项目
    |--------------------------------------------------------------------------
    |
    | resources/views/components/pageitems/
    |
    */

    'Default Email' => '默认电子邮件',
    'Custom Title' => '自定义标题',
    'Leave blank for default title' => '留空以使用默认标题',
    'E-Mail address' => '电子邮件地址',
    'Enter your E-Mail' => '输入您的电子邮件',

    'Heading Text:' => '标题文本:',

    'URL' => '网址',
    'Show website icon on button' => '在按钮上显示网站图标',

    'Select a predefined site' => '选择一个预定义的网站',
    'Enter the link URL' => '输入链接网址',

    'Spacing height' => '间距高度',

    'Phone' => '电话',
    'Telephone number' => '电话号码',
    'Enter your telephone number' => '输入您的电话号码',

    'Text to display' => '要显示的文本',

    'Vcard' => '电子名片',
    'First Name' => '名字',
    'Middle Name' => '中间名',
    'Last Name' => '姓氏',
    'Suffix' => '后缀',
    'Work' => '工作',
    'Organization' => '组织',
    'Work URL' => '工作网址',
    'Emails' => '电子邮件',
    'Enter your personal email' => '输入您的个人电子邮件',
    'Work Email' => '工作电子邮件',
    'Enter your work email' => '输入您的工作电子邮件',
    'Phones' => '电话',
    'Home Phone' => '家庭电话',
    'Work Phone' => '工作电话',
    'Cell Phone' => '手机',
    'Home Address' => '家庭地址',
    'Label' => '标签',
    'Street' => '街道',
    'City' => '城市',
    'State/Province' => '州/省',
    'Zip/Postal Code' => '邮政编码',
    'Country' => '国家',
    'Work Address' => '工作地址',

    'URL to the video' => '视频的网址',


    /*
    |--------------------------------------------------------------------------
    | 维护页面
    |--------------------------------------------------------------------------
    |
    | resources/views/maintenance.blade.php
    |
    */

    'Maintenance Mode' => '维护模式',
    'We are performing scheduled site maintenance at this time' => '我们当前正在进行定期的网站维护。',
    'Please check back with us later' => '请稍后再回来查看。',
    'Admin options:' => '管理员选项：',
    'Turn off' => '关闭',
    'Warn.Disable.Maintenance' => '您即将关闭维护模式。您确定吗？',


    /*
    |--------------------------------------------------------------------------
    | LinkStack (Links) 页面
    |--------------------------------------------------------------------------
    |
    | resources/views/linkstack/linkstack.blade.php
    |
    */

    'Share this page' => '分享此页面',
    'Share' => '分享',
    'Copy URL to clipboard' => '复制网址到剪贴板',
    'URL has been copied to your clipboard!' => '网址已复制到您的剪贴板！',

    'Delete User' => '删除用户',
    'Block User' => '阻止用户',
    'Users Theme' => '主题',
    'Search User' => '搜索用户',

    'Edit my profile' => '编辑我的个人资料',


    /*
    |--------------------------------------------------------------------------
    | 页脚
    |--------------------------------------------------------------------------
    |
    | 添加到某些页面的底部。
    | resources/views/layouts/footer.blade.php
    |
    */

    'Learn more about LinkStack' => '了解更多关于 LinkStack',
    'Learn more' => '了解更多',

    /*
    |--------------------------------------------------------------------------
    | 通知消息
    |--------------------------------------------------------------------------
    |
    | 所有内部通知。
    | resources/views/layouts/notifications.blade.php
    |
    */

    'No notifications' => '没有通知',

    # 安全风险通知
    'Your security is at risk!' => '您的安全性受到威胁！',
    'Immediate action is required!' => '需要立即采取行动！',
    'security.msg1' => '您的安全性受到威胁。',
    'security.msg2' => '一些文件可以被所有人访问。需要立即采取行动！',
    'security.msg3' => '一些重要文件可以公开访问，可能会危及您的安全性。请立即采取行动，撤销对这些文件的公开访问，以防止未经授权访问您的敏感信息。',
    'security.msg4' => '了解更多',

    # 帮助我们通知
    'Hide this notification' => '隐藏此通知',
    'Help Us Out' => '帮助我们',
    'Enjoying Linkstack?' => '喜欢使用 Linkstack 吗？',
    'Support Linkstack' => '支持 Linkstack',
    'support.msg1' => '如果您喜欢使用 Linkstack，我们将非常感激您如果您能花一点时间',
    'support.msg2' => '在 GitHub 上给我们的项目一个星',
    'support.msg3' => '您的支持将帮助我们吸引更广泛的受众，提高我们项目的质量。',
    'support.msg4' => '如果您能',
    'support.msg5' => '提供财政支持</a>，哪怕是一点点，也将有助于我们支付维护和改进 Linkstack 的成本。',
    'support.msg6' => '感谢您的支持，以及您是 LinkStack 社区的一部分！',


    /*
    |--------------------------------------------------------------------------
    | 页脚链接
    |--------------------------------------------------------------------------
    |
    */

    'footer.Home' => '首页',
    'footer.Terms' => '条款',
    'footer.Privacy' => '隐私',
    'footer.Contact' => '联系',


    /*
    |--------------------------------------------------------------------------
    | 报告页面
    |--------------------------------------------------------------------------
    |
    */

    'report_violation' => '报告违规行为',
    'url_label' => '您要举报的网站的网址',
    'report_type_label' => '报告类型',
    'hate_speech' => '仇恨言论或骚扰',
    'violence_threats' => '暴力或威胁',
    'illegal_activities' => '非法活动',
    'copyright_infringement' => '侵犯版权',
    'misinformation_fake_news' => '虚假信息或假新闻',
    'identity_theft' => '身份盗用',
    'drug_related_content' => '与药物相关的内容',
    'weapons_harmful_objects' => '武器或有害物品',
    'child_exploitation' => '儿童剥削',
    'fraud_scams' => '欺诈或骗局',
    'privacy_violation' => '侵犯隐私',
    'impersonation' => '冒充',
    'other_specify' => '其他（请具体说明）',
    'additional_comments_label' => '附加评论',
    'submit_button' => '提交',


    'report_mail_admin_subject' => '个人资料举报',
    'report_mail_admin_report' => '已举报个人资料',

    'report_mail_reported_profile' => '被举报的个人资料',
    'report_mail_reported_url' => '被举报的网址',
    'report_mail_type' => '类型',
    'report_mail_message' => '消息',

    'report_mail_report_submitted_by' => '举报人',
    'report_mail_reported_by' => '被举报人',
    'report_mail_profile' => '个人资料',

    'report_mail_button_profile' => '在用户页面上查看',
    'report_mail_button_delete' => '删除被举报用户',


    'report_error' => '个人资料无法被举报',
    'report_success' => '个人资料已成功举报',


    #=============================================================================#
    # Laravel 内部翻译                                                        #
    #=============================================================================#


    /*
    |--------------------------------------------------------------------------
    | 认证语言线
    |--------------------------------------------------------------------------
    |
    | 以下语言线用于认证过程中的各种消息，我们需要向用户显示这些消息。
    | 您可以根据您的应用程序要求自由修改这些语言线。
    |
    |
    */

    'failed' => '这些凭据与我们的记录不匹配。',
    'password' => '提供的密码不正确。',
    'throttle' => '登录尝试次数过多。请在 :seconds 秒后重试。',


    /*
    |--------------------------------------------------------------------------
    | 分页语言线
    |--------------------------------------------------------------------------
    |
    | 以下语言线由分页器库用于构建简单的分页链接。
    | 您可以根据您的应用程序要求更改它们以更好地匹配您的视图。
    |
    |
    */

    'previous' => '&laquo; 上一页',
    'next' => '下一页 &raquo;',


];
